<?php
/**
* Icon Params
*/

if( !defined( 'ABSPATH' ) )
	exit; // Exit if accessed directly

function liquid_get_icon( $atts = array(), $add_icon = false, $prefix = 'i_' ) {

	$atts = shortcode_atts( array(

		// Icon
		$prefix . 'add_icon'         => false,
		$prefix . 'type'             => 'fontawesome',
		$prefix . 'icon_fontawesome' => false,
		$prefix . 'icon_linea'       => false,
		$prefix . 'icon_animated'         => false,
		$prefix . 'icon_image'       => false,

		//Custom icons
		$prefix . 'icon_liquid_custom_icons' => false,

		// Style
		$prefix . 'color'            => false,
		$prefix . 'hcolor'           => false,
		$prefix . 'align'            => false,
		$prefix . 'size'             => false

	), $atts );

	if( $add_icon && 'true' !== $atts[ $prefix . 'add_icon' ] ) {
		return '';
	}

	if( 'image' === $atts[ $prefix . 'type' ] ) {
		$type = $atts[ $prefix . 'type' ];
		$image_url = isset( $atts[ $prefix . 'icon_' . $type ] ) ? wp_get_attachment_url( $atts[ $prefix . 'icon_' . $type ] ) : '';
		
		return array(
			'type' => $type,
			'src' => $image_url
		);
	}
	elseif( 'animated' === $atts[ $prefix . 'type' ] ) {
		$type = $atts[ $prefix . 'type' ];
		$icon = isset( $atts[ $prefix . 'icon_' . $type ] ) ? esc_attr( $atts[ $prefix . 'icon_' . $type ] ) : 'animated-arrows_anticlockwise';
		$svg  = str_replace( 'animated-', '', $icon );		

		$svg_src = LD_ADDONS_URL . 'assets/vendors/animated-icons/svg/' . $svg . '.svg';
		
		return array(
			'type' => $type,
			'src' => $svg_src,
			'class' => $icon,
		);
	}
	else {
		
		$type = $atts[ $prefix . 'type' ];
		$icon_class = isset( $atts[ $prefix . 'icon_' . $type ] ) ? esc_attr( $atts[ $prefix . 'icon_' . $type ] ) : 'fa fa-adjust';
		$icon_color = isset( $atts[ $prefix . 'color' ] ) ? $atts[ $prefix . 'color' ] : '';
		$icon_hcolor = isset( $atts[ $prefix . 'hcolor' ] ) ? $atts[ $prefix . 'hcolor' ] : '';
		$icon_align = isset( $atts[ $prefix . 'align' ] ) ? $atts[ $prefix . 'align' ] : 'left';
		$icon_size  = isset( $atts[ $prefix . 'size' ] ) ? $atts[ $prefix . 'size' ] : 'size';
		
		if( 'linea' == $type ) {
			if ( !liquid_helper()->str_contains( 'lqd-icn-ess', $icon_class ) ) {
				$icon_class = 'lqd-icn-ess ' . $icon_class;
			}
		}

		vc_icon_element_fonts_enqueue( $type );
	
		return array(
			'type'	=> $type,
			'color'	=> $icon_color,
			'hcolor' => $icon_hcolor,
			'icon'	=> $icon_class,
			'align'	=> $icon_align,
			'size'	=> $icon_size
		);
	}

}

function liquid_get_icon_params( $add_icon = false, $group = '', $fonts = 'all', $remove = array(), $prefix = 'i_', $dependency = array() ) {

	$font_hash = array(
		'fontawesome'     => esc_html__( 'Font Awesome', 'landinghub-core' ),
		'linea'           => esc_html__( 'Liquid Essentials', 'landinghub-core' ),
		'animated'        => esc_html__( 'Animated', 'landinghub-core' ),
		'image'           => esc_html__( 'Image icon', 'landinghub-core' ),
	);
	
	//Add custom icons fonts
	$font_hash = apply_filters( 'liquid_custom_icons_font', $font_hash );

	$settings = array();

	// Add icon field
	if( $add_icon && 'manual' !== $add_icon ) {
		$settings[] = array(
			'type'       => 'checkbox',
			'param_name' => $prefix . 'add_icon',
			'heading'    => esc_html__( 'Add icon?', 'landinghub-core' ),
			'description' => esc_html__( 'Will enable icon on element', 'landinghub-core' ),
		);
	}

// Iconpicker field
	$add_these = $add_these_select = array();
	$add_these_select[esc_html__( 'Select icon font.', 'landinghub-core' )] = '';

	if( 'all' == $fonts ) {
		$fonts = array_keys( $font_hash );
	}

	foreach( $fonts as $font ) {

		$add_these_select[ $font_hash[$font] ] = $font;
		
		if( 'image' === $font ) {
			
			$add_these[] = array(
				'type'        => 'attach_image',
				'param_name'  => $prefix . 'icon_' . $font,
				'heading'     => esc_html__( 'Image', 'landinghub-core' ),
				'dependency'  => array(
					'element' => $prefix . 'type',
					'value'   => $font
				),
				'group' => $group
			);
		}
		else {			
	
			$add_these[] = array(
				'type'       => 'iconpicker',
				'param_name' => $prefix . 'icon_' . $font,
				'heading'    => esc_html__( 'Icon', 'landinghub-core' ),
				'description' => esc_html__( 'Select icon from library.', 'landinghub-core' ),
				'settings' => array(
					'emptyIcon'    => false,
					'type'         => $font,
					'iconsPerPage' => 55
				),
				'dependency' => array(
					'element' => $prefix . 'type',
					'value'   => $font
				),
				'group' => $group
			);	
		}
	}

	// Icon library select field
	$settings[] = array(
		'type'       => 'dropdown',
		'param_name' => $prefix . 'type',
		'heading'    => esc_html__( 'Icon library', 'landinghub-core' ),
		'value'      => $add_these_select,
		'description' => esc_html__( 'Select icon library.', 'landinghub-core' ),
		'dependency'  => ! $add_icon ? $dependency : array(
			'element' => $prefix . 'add_icon',
            'value'   => 'true'
		),
		'group' => $group
	);

	$settings = array_merge( $settings, $add_these );

	// Icon color picker field
	if( ! in_array( 'color', $remove ) ) {
		$settings[] = array(
			'type'        => 'liquid_colorpicker',
			'only_solid'  => true,
			'param_name'  => $prefix . 'color',
			'heading'     => esc_html__( 'Icon color', 'landinghub-core' ),
			'description' => esc_html__( 'Select icon color.', 'landinghub-core' ),
			'edit_field_class' => 'vc_col-sm-6',
			'dependency'  => ! $add_icon ? $dependency : array(
				'element' => $prefix . 'add_icon',
	            'value'   => 'true'
			),
			'group' => esc_html__( 'Design Options', 'landinghub-core' ),
		);
	}
	// Icon color picker field
	if( ! in_array( 'hcolor', $remove ) ) {
		$settings[] = array(
			'type'        => 'liquid_colorpicker',
			'only_solid'  => true,
			'param_name'  => $prefix . 'hcolor',
			'heading'     => esc_html__( 'Icon hover color', 'landinghub-core' ),
			'description' => esc_html__( 'Pick icon hover color.', 'landinghub-core' ),
			'edit_field_class' => 'vc_col-sm-6',
			'dependency'  => ! $add_icon ? $dependency : array(
				'element' => $prefix . 'add_icon',
	            'value'   => 'true'
			),
			'group' => esc_html__( 'Design Options', 'landinghub-core' ),
		);
	}

	// Icon alignment field
	if( ! in_array( 'align', $remove ) ) {
		$settings[] = array(
			'type'       => 'dropdown',
			'param_name' => $prefix . 'align',
			'heading'    => esc_html__( 'Icon alignment', 'landinghub-core' ),
			'edit_field_class' => 'vc_col-sm-6',
			'value'      => array(
				esc_html__( 'Left', 'landinghub-core' )   => 'left',
				esc_html__( 'Right', 'landinghub-core' )  => 'right'
			),
			'description' => esc_html__( 'Select icon alignment.', 'landinghub-core' ),
			'group' => $group,
			'dependency'  => ! $add_icon ? $dependency : array(
				'element' => $prefix . 'add_icon',
	            'value'   => 'true'
			)
		);
	}
	
	// Icon alignment field
	if( ! in_array( 'size', $remove ) ) {
		$settings[] = array(
			'type'       => 'textfield',
			'param_name' => $prefix . 'size',
			'heading'    => esc_html__( 'Icon size', 'landinghub-core' ),
			'edit_field_class' => 'vc_col-sm-6',
			'description' => esc_html__( 'Set custom icon size with px, for ex. 24px', 'landinghub-core' ),
			'group' => $group,
			'dependency'  => ! $add_icon ? $dependency : array(
				'element' => $prefix . 'add_icon',
	            'value'   => 'true'
			)
		);
	}

	foreach( $settings as &$param ) {
		if( empty( $param['group'] ) ) {
			unset($param['group']);
		}
	}

	return $settings;
}

add_filter( 'vc_iconpicker-type-linea', 'liquid_iconpicker_type_liquid_essentials' );
/**
 * [liquid_iconpicker_type_liquid_essentials description]
 * @method liquid_iconpicker_type_liquid_essentials
 * @param  [type]                   $icons [description]
 * @return [type]                          [description]
 */
function liquid_iconpicker_type_liquid_essentials( $icons ) {

	$liquid_essentials = array(

		'Arrow' => array(
			array('lqd-icn-ess icon-md-arrow-back' => 'md-arrow-back'),
			array('lqd-icn-ess icon-md-arrow-down' => 'md-arrow-down'),
			array('lqd-icn-ess icon-md-arrow-forward' => 'md-arrow-forward'),
			array('lqd-icn-ess icon-md-arrow-up' => 'md-arrow-up'),
			array('lqd-icn-ess icon-md-arrow-round-back' => 'md-arrow-round-back'),
			array('lqd-icn-ess icon-md-arrow-round-down' => 'md-arrow-round-down'),
			array('lqd-icn-ess icon-md-arrow-round-forward' => 'md-arrow-round-forward'),
			array('lqd-icn-ess icon-md-arrow-round-up' => 'md-arrow-round-up'),
			array('lqd-icn-ess icon-ion-ios-arrow-round-back' => 'arrow-round-back'),
			array('lqd-icn-ess icon-ion-ios-arrow-round-down' => 'arrow-round-down'),
			array('lqd-icn-ess icon-ion-ios-arrow-round-forward' => 'arrow-round-forward'),
			array('lqd-icn-ess icon-ion-ios-arrow-round-up' => 'arrow-round-up'),
			array('lqd-icn-ess icon-ion-ios-arrow-back' => 'arrow-back'),
			array('lqd-icn-ess icon-ion-ios-arrow-down' => 'arrow-down'),
			array('lqd-icn-ess icon-ion-ios-arrow-forward' => 'arrow-forward'),
			array('lqd-icn-ess icon-ion-ios-arrow-up' => 'arrow-up'),
		),

		'Numbers' => array(
			array('lqd-icn-ess icon-num-1' => 'num-1'),
			array('lqd-icn-ess icon-num-2' => 'num-2'),
			array('lqd-icn-ess icon-num-3' => 'num-3'),
			array('lqd-icn-ess icon-num-4' => 'num-4'),
			array('lqd-icn-ess icon-num-5' => 'num-5'),
			array('lqd-icn-ess icon-num-6' => 'num-6'),
			array('lqd-icn-ess icon-num-7' => 'num-7'),
			array('lqd-icn-ess icon-num-8' => 'num-8'),
			array('lqd-icn-ess icon-num-9' => 'num-9'),
			array('lqd-icn-ess icon-num-10' => 'num-10'),
		),

		'Misc' => array(
			array('lqd-icn-ess icon-ion-ios-add' => 'add'),
			array('lqd-icn-ess icon-ion-ios-checkmark' => 'checkmark'),
			array('lqd-icn-ess icon-ion-ios-close' => 'close'),
			array('lqd-icn-ess icon-ion-ios-remove' => 'remove'),
			array('lqd-icn-ess icon-ld-cart' => 'cart'),
			array('lqd-icn-ess icon-ld-search' => 'search'),
			array('lqd-icn-ess icon-ld-search-2' => 'search 2'),
			array('lqd-icn-ess icon-speech-bubble' => 'speech-bubble'),
			array('lqd-icn-ess icon-lqd-atom' => 'atom'),
			array('lqd-icn-ess icon-lqd-check' => 'check'),
			array('lqd-icn-ess icon-lqd-compass' => 'compass'),
			array('lqd-icn-ess icon-lqd-dollar' => 'dollar'),
			array('lqd-icn-ess icon-lqd-envelope' => 'envelope'),
			array('lqd-icn-ess icon-lqd-laptop' => 'laptop'),
			array('lqd-icn-ess icon-lqd-pen-2' => 'pen-2'),
			array('lqd-icn-ess icon-lqd-pen' => 'pen'),
			array('lqd-icn-ess icon-lqd-stack' => 'stack'),
			array('lqd-icn-ess icon-lqd-user' => 'user'),
			array('lqd-icn-ess icon-lqd-user-2' => 'user 2'),
			array('lqd-icn-ess icon-lqd-feather' => 'feather'),
			array('lqd-icn-ess icon-lqd-smile' => 'smile'),
			array('lqd-icn-ess icon-lqd-eye' => 'eye'),
			array('lqd-icn-ess icon-lqd-sync' => 'sync'),
			array('lqd-icn-ess icon-ion-ios-play' => 'play'),
			array('lqd-icn-ess icon-lqd-volume-low' => 'volume low'),
			array('lqd-icn-ess icon-lqd-volume-high' => 'volume high'),
			array('lqd-icn-ess icon-lqd-bars' => 'bars'),
			array('lqd-icn-ess icon-lqd-dots' => 'dots'),
			array('lqd-icn-ess icon-lqd-dots-alt' => 'dots alt'),
			array('lqd-icn-ess icon-lqd-circle' => 'circle'),
			array('lqd-icn-ess icon-lqd-presentation' => 'Presentation'),
			array('lqd-icn-ess icon-lqd-cogs' => 'Cogs'),
			array('lqd-icn-ess icon-lqd-tools' => 'Tools'),
			array('lqd-icn-ess icon-lqd-mobile' => 'Mobile'),
			array('lqd-icn-ess icon-lqd-target' => 'Target'),
			array('lqd-icn-ess icon-lqd-path' => 'Path'),
		),

	);

	return array_merge( $icons, $liquid_essentials );
}

add_filter( 'vc_iconpicker-type-animated', 'liquid_iconpicker_type_animated' );

function liquid_iconpicker_type_animated( $icons ) {

	$animated_icons = array(
		'Arrows' => array(
			array( 'animated-arrows_anticlockwise' => 'Icon arrow anticlockwise' ),
			array( 'animated-arrows_anticlockwise_dashed' => 'Icon arrow anticlockwise dashed' ),
			array( 'animated-arrows_button_down' => 'Icon arrow button down' ),
			array( 'animated-arrows_button_off' => 'Icon arrow button off' ),
			array( 'animated-arrows_button_on' => 'Icon arrow button on' ),
			array( 'animated-arrows_button_up' => 'Icon arrow button up' ),
			array( 'animated-arrows_check' => 'Icon arrow check' ),
			array( 'animated-arrows_circle_check' => 'Icon arrow circle check' ),
			array( 'animated-arrows_circle_down' => 'Icon arrow circle down' ),			
			array( 'animated-arrows_circle_downleft' => 'Icon arrow circle downleft' ),
			array( 'animated-arrows_circle_downright' => 'Icon arrow circle downright' ),
			array( 'animated-arrows_circle_left' => 'Icon arrow circle left' ),
			array( 'animated-arrows_circle_minus' =>  'Icon arrow circle minus' ),
			array( 'animated-arrows_circle_plus' => 'Icon arrow circle plus' ),
			array( 'animated-arrows_circle_remove' => 'Icon arrow circle remove' ),
			array( 'animated-arrows_circle_right' => 'Icon arrow circle right' ),
			array( 'animated-arrows_circle_up' => 'Icon arrow circle up' ),
			array( 'animated-arrows_circle_upleft' => 'Icon arrow circle upleft' ),
			array( 'animated-arrows_circle_upright' => 'Icon arrow circle upright' ),
			array( 'animated-arrows_clockwise' => 'Icon arrow clockwise' ),
			array( 'animated-arrows_clockwise_dashed' => 'Icon arrow clockwise dashed' ),
			array( 'animated-arrows_compress' => 'Icon arrow compress' ),
			array( 'animated-arrows_deny' => 'Icon arrow deny' ),
			array( 'animated-arrows_diagonal2' => 'Icon arrow diagonal2' ),
			array( 'animated-arrows_diagonal' =>  'Icon arrow diagonal' ),
			array( 'animated-arrows_down' => 'Icon arrow down' ),
			array( 'animated-arrows_down_double-34' => 'Icon arrow down double-34' ),
			array( 'animated-arrows_downleft' => 'Icon arrow downleft' ),
			array( 'animated-arrows_downright' => 'Icon arrow downright' ),
			array( 'animated-arrows_drag_down' => 'Icon arrow drag down' ),
			array( 'animated-arrows_drag_down_dashed' => 'Icon arrow drag down dashed' ),
			array( 'animated-arrows_drag_horiz' => 'Icon arrow drag horiz' ),
			array( 'animated-arrows_drag_left' => 'Icon arrow drag left' ),
			array( 'animated-arrows_drag_left_dashed' => 'Icon arrow drag left dashed' ),
			array( 'animated-arrows_drag_right' => 'Icon arrow drag right' ),
			array( 'animated-arrows_drag_right_dashed' => 'Icon arrow drag right dashed' ),
			array( 'animated-arrows_drag_up' => 'Icon arrow drag up' ),
			array( 'animated-arrows_drag_up_dashed' => 'Icon arrow drag up dashed' ),
			array( 'animated-arrows_drag_vert' => 'Icon arrow drag vert' ),
			array( 'animated-arrows_exclamation' => 'Icon arrow exclamation' ),
			array( 'animated-arrows_expand' => 'Icon arrow expand' ),
			array( 'animated-arrows_expand_diagonal1' => 'Icon arrow expand diagonal1' ),
			array( 'animated-arrows_expand_horizontal1' => 'Icon arrow expand horizontal1' ),
			array( 'animated-arrows_expand_vertical1' => 'Icon arrow expand vertical1' ),
			array( 'animated-arrows_fit_horizontal' => 'Icon arrow fit horizontal' ),
			array( 'animated-arrows_fit_vertical' => 'Icon arrow fit vertical' ),
			array( 'animated-arrows_glide' => 'Icon arrow glide' ),
			array( 'animated-arrows_glide_horizontal' => 'Icon arrow glide horizontal' ),
			array( 'animated-arrows_glide_vertical' => 'Icon arrow glide vertical' ),
			array( 'animated-arrows_hamburger-2' => 'Icon arrow hamburger-2' ),
			array( 'animated-arrows_hamburger1' => 'Icon arrow hamburger1' ),
			array( 'animated-arrows_horizontal' => 'Icon arrow horizontal' ),
			array( 'animated-arrows_info' => 'Icon arrow info' ),
			array( 'animated-arrows_keyboard_alt' => 'Icon arrow keyboard alt' ),
			array( 'animated-arrows_keyboard_cmd-29' => 'Icon arrow keyboard cmd-29' ),
			array( 'animated-arrows_keyboard_delete' => 'Icon arrow keyboard delete' ),
			array( 'animated-arrows_keyboard_down-28' => 'Icon arrow keyboard down-28' ), 
			array( 'animated-arrows_keyboard_left' => 'Icon arrow keyboard left' ), 
			array( 'animated-arrows_keyboard_return' => 'Icon arrow keyboard return' ), 
			array( 'animated-arrows_keyboard_right' => 'Icon arrow keyboard right' ), 
			array( 'animated-arrows_keyboard_shift' => 'Icon arrow keyboard shift' ), 
			array( 'animated-arrows_keyboard_tab' => 'Icon arrow keyboard tab' ), 
			array( 'animated-arrows_keyboard_up' => 'Icon arrow keyboard up' ), 
			array( 'animated-arrows_left' => 'Icon arrow left' ), 
			array( 'animated-arrows_left_double-32' => 'Icon arrow left double-32' ), 
			array( 'animated-arrows_minus' => 'Icon arrow minus' ), 
			array( 'animated-arrows_move2' => 'Icon arrow move2' ), 
			array( 'animated-arrows_move' => 'Icon arrow move' ), 
			array( 'animated-arrows_move_bottom' => 'Icon arrow move bottom' ), 
			array( 'animated-arrows_move_left' => 'Icon arrow move left' ), 
			array( 'animated-arrows_move_right' => 'Icon arrow move right' ), 
			array( 'animated-arrows_move_top' => 'Icon arrow move top' ), 
			array( 'animated-arrows_plus' => 'Icon arrow plus' ), 
			array( 'animated-arrows_question' => 'Icon arrow question' ), 
			array( 'animated-arrows_remove' => 'Icon arrow remove' ), 
			array( 'animated-arrows_right' => 'Icon arrow right' ), 
			array( 'animated-arrows_right_double-31' => 'Icon arrow right double-31' ), 
			array( 'animated-arrows_rotate' => 'Icon arrow rotate' ), 
			array( 'animated-arrows_rotate_anti' => 'Icon arrow rotate anti' ), 
			array( 'animated-arrows_rotate_anti_dashed' => 'Icon arrow rotate anti dashed' ), 
			array( 'animated-arrows_rotate_dashed' => 'Icon arrow rotate dashed' ), 
			array( 'animated-arrows_shrink' => 'Icon arrow shrink' ), 
			array( 'animated-arrows_shrink_diagonal1' => 'Icon arrow shrink diagonal1' ), 
			array( 'animated-arrows_shrink_diagonal2' => 'Icon arrow shrink diagonal2' ), 
			array( 'animated-arrows_shrink_horizonal2' => 'Icon arrow shrink horizonal2' ), 
			array( 'animated-arrows_shrink_horizontal1' => 'Icon arrow shrink horizontal1' ), 
			array( 'animated-arrows_shrink_vertical1' => 'Icon arrow shrink vertical1' ), 
			array( 'animated-arrows_shrink_vertical2' => 'Icon arrow shrink vertical2' ), 
			array( 'animated-arrows_sign_down' => 'Icon arrow sign down' ), 
			array( 'animated-arrows_sign_left' => 'Icon arrow sign left' ), 
			array( 'animated-arrows_sign_right' => 'Icon arrow sign right' ), 
			array( 'animated-arrows_sign_up' => 'Icon arrow sign up' ), 
			array( 'animated-arrows_slide_down1' => 'Icon arrow slide down1' ), 
			array( 'animated-arrows_slide_down2' => 'Icon arrow slide down2' ), 
			array( 'animated-arrows_slide_left1' => 'Icon arrow slide left1' ), 
			array( 'animated-arrows_slide_left2' => 'Icon arrow slide left2' ), 
			array( 'animated-arrows_slide_right1' => 'Icon arrow slide right1' ), 
			array( 'animated-arrows_slide_right2' => 'Icon arrow slide right2' ), 
			array( 'animated-arrows_slide_up1' => 'Icon arrow slide up1' ), 
			array( 'animated-arrows_slide_up2' => 'Icon arrow slide up2' ), 
			array( 'animated-arrows_slim_down' => 'Icon arrow slim down' ), 
			array( 'animated-arrows_slim_down_dashed' => 'Icon arrow slim down dashed' ), 
			array( 'animated-arrows_slim_left' => 'Icon arrow slim left' ), 
			array( 'animated-arrows_slim_left_dashed' => 'Icon arrow slim left dashed' ), 
			array( 'animated-arrows_slim_right' => 'Icon arrow slim right' ), 
			array( 'animated-arrows_slim_right_dashed' => 'Icon arrow slim right dashed' ), 
			array( 'animated-arrows_slim_up' => 'Icon arrow slim up' ), 
			array( 'animated-arrows_slim_up_dashed' => 'Icon arrow slim up dashed' ), 
			array( 'animated-arrows_square_check' => 'Icon arrow square check' ), 
			array( 'animated-arrows_square_down' => 'Icon arrow square down' ), 
			array( 'animated-arrows_square_downleft' => 'Icon arrow square downleft' ), 
			array( 'animated-arrows_square_downright' => 'Icon arrow square downright' ), 
			array( 'animated-arrows_square_left' => 'Icon arrow square left' ), 
			array( 'animated-arrows_square_minus' => 'Icon arrow square minus' ), 
			array( 'animated-arrows_square_plus' => 'Icon arrow square plus' ), 
			array( 'animated-arrows_square_remove' => 'Icon arrow square remove' ), 
			array( 'animated-arrows_square_right' => 'Icon arrow square right' ), 
			array( 'animated-arrows_square_up' => 'Icon arrow square up' ), 
			array( 'animated-arrows_square_upleft' => 'Icon arrow square upleft' ), 
			array( 'animated-arrows_square_upright' => 'Icon arrow square upright' ), 
			array( 'animated-arrows_squares' => 'Icon arrow squares' ), 
			array( 'animated-arrows_stretch_diagonal1' => 'Icon arrow stretch diagonal1' ), 
			array( 'animated-arrows_stretch_diagonal2' => 'Icon arrow stretch diagonal2' ), 
			array( 'animated-arrows_stretch_diagonal3' => 'Icon arrow stretch diagonal3' ), 
			array( 'animated-arrows_stretch_diagonal4' => 'Icon arrow stretch diagonal4' ), 
			array( 'animated-arrows_stretch_horizontal1' => 'Icon arrow stretch horizontal1' ), 
			array( 'animated-arrows_stretch_horizontal2' => 'Icon arrow stretch horizontal2' ), 
			array( 'animated-arrows_stretch_vertical1' => 'Icon arrow stretch vertical1' ), 
			array( 'animated-arrows_stretch_vertical2' => 'Icon arrow stretch vertical2' ), 
			array( 'animated-arrows_switch_horizontal' => 'Icon arrow switch horizontal' ), 
			array( 'animated-arrows_switch_vertical' => 'Icon arrow switch vertical' ), 
			array( 'animated-arrows_up' => 'Icon arrow up' ), 
			array( 'animated-arrows_up_double-33' => 'Icon arrow up double-33' ), 
			array( 'animated-arrows_upleft' => 'Icon arrow upleft' ), 
			array( 'animated-arrows_upright' => 'Icon arrow upright' ), 
			array( 'animated-arrows_vertical' => 'Icon arrow vertical'),
		),
		'Basic' => array(
			array( 'animated-basic_accelerator' => 'Icon basic accelerator' ), 
			array( 'animated-basic_alarm' => 'Icon basic alarm' ), 
			array( 'animated-basic_anchor' => 'Icon basic anchor' ), 
			array( 'animated-basic_anticlockwise' => 'Icon basic anticlockwise' ), 
			array( 'animated-basic_archive' => 'Icon basic archive' ), 
			array( 'animated-basic_archive_full' => 'Icon basic archive full' ), 
			array( 'animated-basic_ban' => 'Icon basic ban' ), 
			array( 'animated-basic_battery_charge' => 'Icon basic battery charge' ), 
			array( 'animated-basic_battery_empty' => 'Icon basic battery empty' ), 
			array( 'animated-basic_battery_full' => 'Icon basic battery full' ), 
			array( 'animated-basic_battery_half' => 'Icon basic battery half' ), 
			array( 'animated-basic_bolt' => 'Icon basic bolt' ), 
			array( 'animated-basic_book' => 'Icon basic book' ), 
			array( 'animated-basic_book_pen' => 'Icon basic book pen' ), 
			array( 'animated-basic_book_pencil' => 'Icon basic book pencil' ), 
			array( 'animated-basic_bookmark' => 'Icon basic bookmark' ), 
			array( 'animated-basic_calculator' => 'Icon basic calculator' ), 
			array( 'animated-basic_calendar' => 'Icon basic calendar' ), 
			array( 'animated-basic_cards_diamonds' => 'Icon basic cards diamonds' ), 
			array( 'animated-basic_cards_hearts' => 'Icon basic cards hearts' ), 
			array( 'animated-basic_case' => 'Icon basic case' ), 
			array( 'animated-basic_chronometer' => 'Icon basic chronometer' ), 
			array( 'animated-basic_clessidre' => 'Icon basic clessidre' ), 
			array( 'animated-basic_clock' => 'Icon basic clock' ), 
			array( 'animated-basic_clockwise' => 'Icon basic clockwise' ), 
			array( 'animated-basic_cloud' => 'Icon basic cloud' ), 
			array( 'animated-basic_clubs' => 'Icon basic clubs' ), 
			array( 'animated-basic_compass' => 'Icon basic compass' ), 
			array( 'animated-basic_cup' => 'Icon basic cup' ), 
			array( 'animated-basic_diamonds' => 'Icon basic diamonds' ), 
			array( 'animated-basic_display' => 'Icon basic display' ), 
			array( 'animated-basic_download' => 'Icon basic download' ), 
			array( 'animated-basic_exclamation' => 'Icon basic exclamation' ), 
			array( 'animated-basic_eye' => 'Icon basic eye' ), 
			array( 'animated-basic_eye_closed' => 'Icon basic eye closed' ), 
			array( 'animated-basic_female' => 'Icon basic female' ), 
			array( 'animated-basic_flag1' => 'Icon basic flag1' ), 
			array( 'animated-basic_flag2' => 'Ico basic flag2' ), 
			array( 'animated-basic_floppydisk' => 'Icon basic floppydisk' ), 
			array( 'animated-basic_folder' => 'Icon basic folder' ), 
			array( 'animated-basic_folder_multiple' => 'Icon basic folder multiple' ), 
			array( 'animated-basic_gear' => 'Icon basic gear' ), 
			array( 'animated-basic_geolocalize-01' => 'Icon basic geolocalize-01' ), 
			array( 'animated-basic_geolocalize-05' => 'Icon basic geolocalize-05' ), 
			array( 'animated-basic_globe' => 'Icon basic globe' ), 
			array( 'animated-basic_gunsight' => 'Icon basic gunsight' ), 
			array( 'animated-basic_hammer' => 'Icon basic hammer' ), 
			array( 'animated-basic_headset' => 'Icon basic headset' ), 
			array( 'animated-basic_heart' => 'Icon basic heart' ), 
			array( 'animated-basic_heart_broken' => 'Icon basic heart broken' ), 
			array( 'animated-basic_helm' => 'Icon basic helm' ), 
			array( 'animated-basic_home' => 'Icon basic home' ), 
			array( 'animated-basic_info' => 'Icon basic info' ), 
			array( 'animated-basic_ipod' => 'Basic ipod' ), 
			array( 'animated-basic_joypad' => 'Basic joypad' ), 
			array( 'animated-basic_key' => 'Basic key' ), 
			array( 'animated-basic_keyboard' => 'Basic keyboard' ), 
			array( 'animated-basic_laptop' => 'Basic laptop' ), 
			array( 'animated-basic_life_buoy' => 'Basic life buoy' ), 
			array( 'animated-basic_lightbulb' => 'Basic lightbulb' ), 
			array( 'animated-basic_link' => 'Basic link' ), 
			array( 'animated-basic_lock' => 'Basic lock' ), 
			array( 'animated-basic_lock_open' => 'Basic lock open' ), 
			array( 'animated-basic_magic_mouse' => 'Basic magic mouse' ), 
			array( 'animated-basic_magnifier' => 'Basic magnifier' ), 
			array( 'animated-basic_magnifier_minus' => 'Basic magnifier minus' ), 
			array( 'animated-basic_magnifier_plus' => 'Basic magnifier plus' ), 
			array( 'animated-basic_mail' => 'Basic mail' ), 
			array( 'animated-basic_mail_multiple' => 'Basic mail multiple' ), 
			array( 'animated-basic_mail_open' => 'Basic mail open' ), 
			array( 'animated-basic_mail_open_text' => 'Basic mail open text' ), 
			array( 'animated-basic_male' => 'Basic male' ),
			array( 'animated-basic_map' => 'Basic map' ), 
			array( 'animated-basic_message' => 'Basic message' ), 
			array( 'animated-basic_message_multiple' => 'Basic message multiple' ), 
			array( 'animated-basic_message_txt' => 'Basic message txt' ), 
			array( 'animated-basic_mixer2' => 'Basic mixer2' ), 
			array( 'animated-basic_mouse' => 'Basic mouse' ), 
			array( 'animated-basic_notebook' => 'Basic notebook' ), 
			array( 'animated-basic_notebook_pen' => 'basic notebook pen' ), 
			array( 'animated-basic_notebook_pencil' => 'basic notebook pencil' ), 
			array( 'animated-basic_paperplane' => 'basic paperplane' ), 
			array( 'animated-basic_pencil_ruler' => 'basic pencil ruler' ), 
			array( 'animated-basic_pencil_ruler_pen' => 'basic pencil ruler pen' ), 
			array( 'animated-basic_photo' => 'basic photo' ), 
			array( 'animated-basic_picture' => 'basic picture' ), 
			array( 'animated-basic_picture_multiple' => 'basic picture multiple' ), 
			array( 'animated-basic_pin1' => 'basic pin1' ), 
			array( 'animated-basic_pin2' => 'basic pin2' ), 
			array( 'animated-basic_postcard' => 'basic postcard' ), 
			array( 'animated-basic_postcard_multiple' => 'basic postcard multiple' ), 
			array( 'animated-basic_printer' => 'basic printer' ), 
			array( 'animated-basic_question' => 'basic question' ), 
			array( 'animated-basic_rss' => 'basic rss' ), 
			array( 'animated-basic_server2' => 'basic server2' ), 
			array( 'animated-basic_server' => 'basic server' ), 
			array( 'animated-basic_server_cloud' => 'basic server cloud' ), 
			array( 'animated-basic_server_download' => 'basic server download' ), 
			array( 'animated-basic_server_upload' => 'basic server upload' ), 
			array( 'animated-basic_settings' => 'basic settings' ), 
			array( 'animated-basic_share' => 'basic share' ), 
			array( 'animated-basic_sheet' => 'basic sheet' ), 
			array( 'animated-basic_sheet_multiple' => 'basic sheet multiple' ), 
			array( 'animated-basic_sheet_pen' => 'basic sheet pen' ), 
			array( 'animated-basic_sheet_pencil' => 'basic sheet pencil' ), 
			array( 'animated-basic_sheet_txt' => 'basic sheet txt' ), 
			array( 'animated-basic_signs' => 'basic signs' ), 
			array( 'animated-basic_smartphone' => 'basic smartphone' ), 
			array( 'animated-basic_spades' => 'basic spades' ), 
			array( 'animated-basic_spread' => 'basic spread' ), 
			array( 'animated-basic_spread_bookmark' => 'basic spread bookmark' ), 
			array( 'animated-basic_spread_text' => 'basic spread text' ), 
			array( 'animated-basic_spread_text_bookmark' => 'basic spread text bookmark' ), 
			array( 'animated-basic_star' => 'basic star' ), 
			array( 'animated-basic_tablet' => 'basic tablet' ), 
			array( 'animated-basic_target' => 'basic target' ), 
			array( 'animated-basic_todo' => 'basic todo' ), 
			array( 'animated-basic_todo_pen' => 'basic todo pen' ), 
			array( 'animated-basic_todo_pencil' => 'basic todo pencil' ), 
			array( 'animated-basic_todo_txt' => 'basic todo txt' ), 
			array( 'animated-basic_todolist_pen' => 'basic todolist pen' ), 
			array( 'animated-basic_todolist_pencil' => 'basic todolist pencil' ), 
			array( 'animated-basic_trashcan' => 'basic trashcan' ), 
			array( 'animated-basic_trashcan_full' => 'basic trashcan full' ), 
			array( 'animated-basic_trashcan_refresh' => 'basic trashcan refresh' ), 
			array( 'animated-basic_trashcan_remove' => 'basic trashcan remove' ), 
			array( 'animated-basic_upload' => 'basic upload' ), 
			array( 'animated-basic_usb' => 'basic usb' ), 
			array( 'animated-basic_video' => 'basic video' ), 
			array( 'animated-basic_watch' => 'basic watch' ), 
			array( 'animated-basic_webpage' => 'basic webpage' ), 
			array( 'animated-basic_webpage_img_txt' => 'basic webpage img txt' ), 
			array( 'animated-basic_webpage_multiple' => 'basic webpage multiple' ), 
			array( 'animated-basic_webpage_txt' => 'basic webpage txt' ), 
			array( 'animated-basic_world' => 'basic world' ),
		),
		'Basic Elaboration' => array(
			array( 'animated-basic_elaboration_bookmark_checck' => 'basic elaboration bookmark checck' ),
			array( 'animated-basic_elaboration_bookmark_minus' => 'basic elaboration bookmark minus' ), 
			array( 'animated-basic_elaboration_bookmark_plus' => 'basic elaboration bookmark plus' ), 
			array( 'animated-basic_elaboration_bookmark_remove' => 'basic elaboration bookmark remove' ), 
			array( 'animated-basic_elaboration_briefcase_check' => 'basic elaboration briefcase check' ), 
			array( 'animated-basic_elaboration_briefcase_download' => 'basic elaboration briefcase download' ), 
			array( 'animated-basic_elaboration_briefcase_flagged' => 'basic elaboration briefcase flagged' ), 
			array( 'animated-basic_elaboration_briefcase_minus' => 'basic elaboration briefcase minus' ), 
			array( 'animated-basic_elaboration_briefcase_plus' => 'basic elaboration briefcase plus' ), 
			array( 'animated-basic_elaboration_briefcase_refresh' => 'basic elaboration briefcase refresh' ),
			array( 'animated-basic_elaboration_briefcase_remove' => 'basic elaboration briefcase remove' ), 
			array( 'animated-basic_elaboration_briefcase_search' => 'basic elaboration briefcase search' ), 
			array( 'animated-basic_elaboration_briefcase_star' => 'basic elaboration briefcase star' ), 
			array( 'animated-basic_elaboration_briefcase_upload' => 'basic elaboration briefcase upload' ), 
			array( 'animated-basic_elaboration_browser_check' => 'basic elaboration browser check' ), 
			array( 'animated-basic_elaboration_browser_download' => 'basic elaboration browser download' ), 
			array( 'animated-basic_elaboration_browser_minus' => 'basic elaboration browser minus' ), 
			array( 'animated-basic_elaboration_browser_plus' => 'basic elaboration browser plus' ), 
			array( 'animated-basic_elaboration_browser_refresh' => 'basic elaboration browser refresh' ), 
			array( 'animated-basic_elaboration_browser_remove' => 'basic elaboration browser remove' ), 
			array( 'animated-basic_elaboration_browser_search' => 'basic elaboration browser search' ), 
			array( 'animated-basic_elaboration_browser_star' => 'basic elaboration browser star' ), 
			array( 'animated-basic_elaboration_browser_upload' => 'basic elaboration browser upload' ), 
			array( 'animated-basic_elaboration_calendar_check' => 'basic elaboration calendar check' ), 
			array( 'animated-basic_elaboration_calendar_cloud' => 'basic elaboration calendar cloud' ), 
			array( 'animated-basic_elaboration_calendar_download' => 'basic elaboration calendar download' ), 
			array( 'animated-basic_elaboration_calendar_empty' => 'basic elaboration calendar empty' ), 
			array( 'animated-basic_elaboration_calendar_flagged' => 'basic elaboration calendar flagged' ), 
			array( 'animated-basic_elaboration_calendar_heart' => 'basic elaboration calendar heart' ), 
			array( 'animated-basic_elaboration_calendar_minus' => 'basic elaboration calendar minus' ), 
			array( 'animated-basic_elaboration_calendar_next' => 'basic elaboration calendar next' ), 
			array( 'animated-basic_elaboration_calendar_noaccess' => 'basic elaboration calendar noaccess' ), 
			array( 'animated-basic_elaboration_calendar_pencil' => 'basic elaboration calendar pencil' ), 
			array( 'animated-basic_elaboration_calendar_plus' => 'basic elaboration calendar plus' ), 
			array( 'animated-basic_elaboration_calendar_previous' => 'basic elaboration calendar previous' ), 
			array( 'animated-basic_elaboration_calendar_refresh' => 'basic elaboration calendar refresh' ), 
			array( 'animated-basic_elaboration_calendar_remove' => 'basic elaboration calendar remove' ), 
			array( 'animated-basic_elaboration_calendar_search' => 'basic elaboration calendar search' ), 
			array( 'animated-basic_elaboration_calendar_star' => 'basic elaboration calendar star' ), 
			array( 'animated-basic_elaboration_calendar_upload' => 'basic elaboration calendar upload' ), 
			array( 'animated-basic_elaboration_cloud_check' => 'basic elaboration cloud check' ), 
			array( 'animated-basic_elaboration_cloud_download' => 'basic elaboration cloud download' ), 
			array( 'animated-basic_elaboration_cloud_minus' => 'basic elaboration cloud minus' ), 
			array( 'animated-basic_elaboration_cloud_noaccess' => 'basic elaboration cloud noaccess' ), 
			array( 'animated-basic_elaboration_cloud_plus' => 'basic elaboration cloud plus' ), 
			array( 'animated-basic_elaboration_cloud_refresh' => 'basic elaboration cloud refresh' ), 
			array( 'animated-basic_elaboration_cloud_remove' => 'basic elaboration cloud remove' ), 
			array( 'animated-basic_elaboration_cloud_search' => 'basic elaboration cloud search' ), 
			array( 'animated-basic_elaboration_cloud_upload' => 'basic elaboration cloud upload' ), 
			array( 'animated-basic_elaboration_document_check' => 'basic elaboration document check' ), 
			array( 'animated-basic_elaboration_document_cloud' => 'basic elaboration document cloud' ), 
			array( 'animated-basic_elaboration_document_download' => 'basic elaboration document download' ), 
			array( 'animated-basic_elaboration_document_flagged' => 'basic elaboration document flagged' ), 
			array( 'animated-basic_elaboration_document_graph' => 'basic elaboration document graph' ), 
			array( 'animated-basic_elaboration_document_heart' => 'basic elaboration document heart' ), 
			array( 'animated-basic_elaboration_document_minus' => 'basic elaboration document minus' ), 
			array( 'animated-basic_elaboration_document_next' => 'basic elaboration document next' ), 
			array( 'animated-basic_elaboration_document_noaccess' => 'basic elaboration document noaccess' ), 
			array( 'animated-basic_elaboration_document_note' => 'basic elaboration document note' ), 
			array( 'animated-basic_elaboration_document_pencil' => 'basic elaboration document pencil' ), 
			array( 'animated-basic_elaboration_document_picture' => 'basic elaboration document picture' ), 
			array( 'animated-basic_elaboration_document_plus' => 'basic elaboration document plus' ), 
			array( 'animated-basic_elaboration_document_previous' => 'basic elaboration document previous' ), 
			array( 'animated-basic_elaboration_document_refresh' => 'basic elaboration document refresh' ), 
			array( 'animated-basic_elaboration_document_remove' => 'basic elaboration document remove' ), 
			array( 'animated-basic_elaboration_document_search' => 'basic elaboration document search' ), 
			array( 'animated-basic_elaboration_document_star' => 'basic elaboration document star' ), 
			array( 'animated-basic_elaboration_document_upload' => 'basic elaboration document upload' ), 
			array( 'animated-basic_elaboration_folder_check' => 'basic elaboration folder check' ), 
			array( 'animated-basic_elaboration_folder_cloud' => 'basic elaboration folder cloud' ), 
			array( 'animated-basic_elaboration_folder_document' => 'basic elaboration folder document' ), 
			array( 'animated-basic_elaboration_folder_download' => 'basic elaboration folder download' ), 
			array( 'animated-basic_elaboration_folder_flagged' => 'basic elaboration folder flagged' ), 
			array( 'animated-basic_elaboration_folder_graph' => 'basic elaboration folder graph' ), 
			array( 'animated-basic_elaboration_folder_heart' => 'basic elaboration folder heart' ), 
			array( 'animated-basic_elaboration_folder_minus' => 'basic elaboration folder minus' ), 
			array( 'animated-basic_elaboration_folder_next' => 'basic elaboration folder next' ), 
			array( 'animated-basic_elaboration_folder_noaccess' => 'basic elaboration folder noaccess' ), 
			array( 'animated-basic_elaboration_folder_note' => 'basic elaboration folder note' ), 
			array( 'animated-basic_elaboration_folder_pencil' => 'basic elaboration folder pencil' ), 
			array( 'animated-basic_elaboration_folder_picture' => 'basic elaboration folder picture' ), 
			array( 'animated-basic_elaboration_folder_plus' => 'basic elaboration folder plus' ), 
			array( 'animated-basic_elaboration_folder_previous' => 'basic elaboration folder previous' ), 
			array( 'animated-basic_elaboration_folder_refresh' => 'basic elaboration folder refresh' ), 
			array( 'animated-basic_elaboration_folder_remove' => 'basic elaboration folder remove' ), 
			array( 'animated-basic_elaboration_folder_search' => 'basic elaboration folder search' ), 
			array( 'animated-basic_elaboration_folder_star' => 'basic elaboration folder star' ), 
			array( 'animated-basic_elaboration_folder_upload' => 'basic elaboration folder upload' ), 
			array( 'animated-basic_elaboration_mail_check' => 'basic elaboration mail check' ), 
			array( 'animated-basic_elaboration_mail_cloud' => 'basic elaboration mail cloud' ), 
			array( 'animated-basic_elaboration_mail_document' => 'basic elaboration mail document' ), 
			array( 'animated-basic_elaboration_mail_download' => 'basic elaboration mail download' ), 
			array( 'animated-basic_elaboration_mail_flagged' => 'basic elaboration mail flagged' ), 
			array( 'animated-basic_elaboration_mail_heart' => 'basic elaboration mail heart' ), 
			array( 'animated-basic_elaboration_mail_next' => 'basic elaboration mail next' ), 
			array( 'animated-basic_elaboration_mail_noaccess' => 'basic elaboration mail noaccess' ), 
			array( 'animated-basic_elaboration_mail_note' => 'basic elaboration mail note' ), 
			array( 'animated-basic_elaboration_mail_pencil' => 'basic elaboration mail pencil' ), 
			array( 'animated-basic_elaboration_mail_picture' => 'basic elaboration mail picture' ), 
			array( 'animated-basic_elaboration_mail_previous' => 'basic elaboration mail previous' ), 
			array( 'animated-basic_elaboration_mail_refresh' => 'basic elaboration mail refresh' ), 
			array( 'animated-basic_elaboration_mail_remove' => 'basic elaboration mail remove' ), 
			array( 'animated-basic_elaboration_mail_search' => 'basic elaboration mail search' ), 
			array( 'animated-basic_elaboration_mail_star' => 'basic elaboration mail star' ), 
			array( 'animated-basic_elaboration_mail_upload' => 'basic elaboration mail upload' ), 
			array( 'animated-basic_elaboration_message_check' => 'basic elaboration message check' ), 
			array( 'animated-basic_elaboration_message_dots' => 'basic elaboration message dots' ), 
			array( 'animated-basic_elaboration_message_happy' => 'basic elaboration message happy' ), 
			array( 'animated-basic_elaboration_message_heart' => 'basic elaboration message heart' ), 
			array( 'animated-basic_elaboration_message_minus' => 'basic elaboration message minus' ), 
			array( 'animated-basic_elaboration_message_note' => 'basic elaboration message note' ), 
			array( 'animated-basic_elaboration_message_plus' => 'basic elaboration message plus' ), 
			array( 'animated-basic_elaboration_message_refresh' => 'basic elaboration message refresh' ), 
			array( 'animated-basic_elaboration_message_remove' => 'basic elaboration message remove' ), 
			array( 'animated-basic_elaboration_message_sad' => 'basic elaboration message sad' ), 
			array( 'animated-basic_elaboration_smartphone_cloud' => 'basic elaboration smartphone cloud' ), 
			array( 'animated-basic_elaboration_smartphone_heart' => 'basic elaboration smartphone heart' ), 
			array( 'animated-basic_elaboration_smartphone_noaccess' => 'basic elaboration smartphone noaccess' ), 
			array( 'animated-basic_elaboration_smartphone_note' => 'basic elaboration smartphone note' ), 
			array( 'animated-basic_elaboration_smartphone_pencil' => 'basic elaboration smartphone pencil' ), 
			array( 'animated-basic_elaboration_smartphone_picture' => 'basic elaboration smartphone picture' ), 
			array( 'animated-basic_elaboration_smartphone_refresh' => 'basic elaboration smartphone refresh' ), 
			array( 'animated-basic_elaboration_smartphone_search' => 'basic elaboration smartphone search' ), 
			array( 'animated-basic_elaboration_tablet_cloud' => 'basic elaboration tablet cloud' ), 
			array( 'animated-basic_elaboration_tablet_heart' => 'basic elaboration tablet heart' ), 
			array( 'animated-basic_elaboration_tablet_noaccess' => 'basic elaboration tablet noaccess' ), 
			array( 'animated-basic_elaboration_tablet_note' => 'basic elaboration tablet note' ), 
			array( 'animated-basic_elaboration_tablet_pencil' => 'basic elaboration tablet pencil' ), 
			array( 'animated-basic_elaboration_tablet_picture' => 'basic elaboration tablet picture' ), 
			array( 'animated-basic_elaboration_tablet_refresh' => 'basic elaboration tablet refresh' ), 
			array( 'animated-basic_elaboration_tablet_search' => 'basic elaboration tablet search' ), 
			array( 'animated-basic_elaboration_todolist_2' => 'basic elaboration todolist_2' ), 
			array( 'animated-basic_elaboration_todolist_check' => 'basic elaboration todolist check' ), 
			array( 'animated-basic_elaboration_todolist_cloud' => 'basic elaboration todolist cloud' ), 
			array( 'animated-basic_elaboration_todolist_download' => 'basic elaboration todolist download' ), 
			array( 'animated-basic_elaboration_todolist_flagged' => 'basic elaboration todolist flagged' ), 
			array( 'animated-basic_elaboration_todolist_minus' => 'basic elaboration todolist minus' ), 
			array( 'animated-basic_elaboration_todolist_noaccess' => 'basic elaboration todolist noaccess' ), 
			array( 'animated-basic_elaboration_todolist_pencil' => 'basic elaboration todolist pencil' ), 
			array( 'animated-basic_elaboration_todolist_plus' => 'basic elaboration todolist plus' ), 
			array( 'animated-basic_elaboration_todolist_refresh' => 'basic elaboration todolist refresh' ), 
			array( 'animated-basic_elaboration_todolist_remove' => 'basic elaboration todolist remove' ), 
			array( 'animated-basic_elaboration_todolist_search' => 'basic elaboration todolist search' ), 
			array( 'animated-basic_elaboration_todolist_star' => 'basic elaboration todolist star' ), 
			array( 'animated-basic_elaboration_todolist_upload' => 'basic elaboration todolist upload' ),
		),
		'Ecommerce' => array(
			array( 'animated-ecommerce_bag' => 'ecommerce bag' ), 
			array( 'animated-ecommerce_bag_check' => 'ecommerce bag check' ), 
			array( 'animated-ecommerce_bag_cloud' => 'ecommerce bag cloud' ), 
			array( 'animated-ecommerce_bag_download' => 'ecommerce bag download' ), 
			array( 'animated-ecommerce_bag_minus' => 'ecommerce bag minus' ), 
			array( 'animated-ecommerce_bag_plus' => 'ecommerce bag plus' ), 
			array( 'animated-ecommerce_bag_refresh' => 'ecommerce bag refresh' ), 
			array( 'animated-ecommerce_bag_remove' => 'ecommerce bag remove' ), 
			array( 'animated-ecommerce_bag_search' => 'ecommerce bag search' ), 
			array( 'animated-ecommerce_bag_upload' => 'ecommerce bag upload' ), 
			array( 'animated-ecommerce_banknote' => 'ecommerce banknote' ), 
			array( 'animated-ecommerce_banknotes' => 'ecommerce banknotes' ), 
			array( 'animated-ecommerce_basket' => 'ecommerce basket' ), 
			array( 'animated-ecommerce_basket_check' => 'ecommerce basket check' ), 
			array( 'animated-ecommerce_basket_cloud' => 'ecommerce basket cloud' ), 
			array( 'animated-ecommerce_basket_download' => 'ecommerce basket download' ), 
			array( 'animated-ecommerce_basket_minus' => 'ecommerce basket minus' ), 
			array( 'animated-ecommerce_basket_plus' => 'ecommerce basket plus' ), 
			array( 'animated-ecommerce_basket_refresh' => 'ecommerce basket refresh' ), 
			array( 'animated-ecommerce_basket_remove' => 'ecommerce basket remove' ), 
			array( 'animated-ecommerce_basket_search' => 'ecommerce basket search' ), 
			array( 'animated-ecommerce_basket_upload' => 'ecommerce basket upload' ), 
			array( 'animated-ecommerce_bath' => 'ecommerce bath' ), 
			array( 'animated-ecommerce_cart' => 'ecommerce cart' ), 
			array( 'animated-ecommerce_cart_check' => 'ecommerce cart check' ), 
			array( 'animated-ecommerce_cart_cloud' => 'ecommerce cart cloud' ), 
			array( 'animated-ecommerce_cart_content' => 'ecommerce cart content' ), 
			array( 'animated-ecommerce_cart_download' => 'ecommerce cart download' ), 
			array( 'animated-ecommerce_cart_minus' => 'ecommerce cart minus' ), 
			array( 'animated-ecommerce_cart_plus' => 'ecommerce cart plus' ), 
			array( 'animated-ecommerce_cart_refresh' => 'ecommerce cart refresh' ), 
			array( 'animated-ecommerce_cart_remove' => 'ecommerce cart remove' ), 
			array( 'animated-ecommerce_cart_search' => 'ecommerce cart search' ), 
			array( 'animated-ecommerce_cart_upload' => 'ecommerce cart upload' ), 
			array( 'animated-ecommerce_creditcard' => 'ecommerce creditcard' ), 
			array( 'animated-ecommerce_diamond' => 'ecommerce diamond' ),
			array( 'animated-ecommerce_gift' => 'ecommerce gift' ), 
			array( 'animated-ecommerce_graph1' => 'ecommerce graph1' ), 
			array( 'animated-ecommerce_graph2' => 'ecommerce graph2' ), 
			array( 'animated-ecommerce_graph3' => 'ecommerce graph3' ), 
			array( 'animated-ecommerce_graph_decrease' => 'ecommerce graph decrease' ), 
			array( 'animated-ecommerce_graph_increase' => 'ecommerce graph increase' ),
			array( 'animated-ecommerce_megaphone' => 'ecommerce megaphone' ), 
			array( 'animated-ecommerce_money' => 'ecommerce money' ), 
			array( 'animated-ecommerce_naira' => 'ecommerce naira' ), 
			array( 'animated-ecommerce_pesos' => 'ecommerce pesos' ), 
			array( 'animated-ecommerce_pound' => 'ecommerce pound' ), 
			array( 'animated-ecommerce_receipt' => 'ecommerce receipt' ), 
			array( 'animated-ecommerce_receipt_bath' => 'ecommerce receipt bath' ), 
			array( 'animated-ecommerce_receipt_cent' => 'ecommerce receipt cent' ), 
			array( 'animated-ecommerce_receipt_dollar' => 'ecommerce receipt dollar' ), 
			array( 'animated-ecommerce_receipt_euro' => 'ecommerce receipt euro' ), 
			array( 'animated-ecommerce_receipt_franc' => 'ecommerce receipt franc' ), 
			array( 'animated-ecommerce_receipt_guarani' => 'ecommerce receipt guarani' ), 
			array( 'animated-ecommerce_receipt_kips' => 'ecommerce receipt kips' ), 
			array( 'animated-ecommerce_receipt_lira' => 'ecommerce receipt lira' ), 
			array( 'animated-ecommerce_receipt_tugrik' => 'ecommerce receipt tugrik' ), 
			array( 'animated-ecommerce_receipt_won' => 'ecommerce receipt won' ), 
			array( 'animated-ecommerce_receipt_yen2' => 'ecommerce receipt yen2' ), 
			array( 'animated-ecommerce_receipt_yen' => 'ecommerce receipt yen' ), 
			array( 'animated-ecommerce_recept_colon' => 'ecommerce recept colon' ), 
			array( 'animated-ecommerce_rublo' => 'ecommerce rublo' ), 
			array( 'animated-ecommerce_rupee' => 'ecommerce rupee' ), 
			array( 'animated-ecommerce_safe' => 'ecommerce safe' ), 
			array( 'animated-ecommerce_sale' => 'ecommerce sale' ), 
			array( 'animated-ecommerce_sales' => 'ecommerce sales' ), 
			array( 'animated-ecommerce_ticket' => 'ecommerce ticket' ), 
			array( 'animated-ecommerce_wallet' => 'ecommerce wallet' ),
		),
		'Music' => array(
			array( 'animated-music_beginning_button' => 'music beginning button' ), 
			array( 'animated-music_bell' => 'music bell' ), 
			array( 'animated-music_cd' => 'music cd' ), 
			array( 'animated-music_diapason' => 'music diapason' ), 
			array( 'animated-music_eject_button' => 'music eject button' ), 
			array( 'animated-music_end_button' => 'music end button' ), 
			array( 'animated-music_fastforward_button' => 'music fastforward button' ), 
			array( 'animated-music_headphones' => 'music headphones' ), 
			array( 'animated-music_ipod' => 'music ipod' ), 
			array( 'animated-music_loudspeaker' => 'music loudspeaker' ), 
			array( 'animated-music_microphone' => 'music microphone' ), 
			array( 'animated-music_microphone_old' => 'music microphone old' ), 
			array( 'animated-music_mixer' => 'music mixer' ), 
			array( 'animated-music_mute' => 'music mute' ), 
			array( 'animated-music_note_multiple' => 'music note multiple' ), 
			array( 'animated-music_note_single' => 'music note single' ), 
			array( 'animated-music_pause_button' => 'music pause button' ), 
			array( 'animated-music_play_button' => 'music play button' ), 
			array( 'animated-music_playlist' => 'music playlist' ), 
			array( 'animated-music_radio_ghettoblaster' => 'music radio ghettoblaster' ), 
			array( 'animated-music_radio_portable' => 'music radio portable' ), 
			array( 'animated-music_record' => 'music record' ), 
			array( 'animated-music_recordplayer' => 'music recordplayer' ), 
			array( 'animated-music_repeat_button' => 'music repeat button' ), 
			array( 'animated-music_rewind_button' => 'music rewind button' ), 
			array( 'animated-music_shuffle_button' => 'music shuffle button' ), 
			array( 'animated-music_stop_button' => 'music stop button' ), 
			array( 'animated-music_tape' => 'music tape' ), 
			array( 'animated-music_volume_down' => 'music volume down' ), 
			array( 'animated-music_volume_up' => 'music volume up' ), 
		),
		'Software' => array(
			array( 'animated-software-horizontal_align_left' => 'software horizontal align left' ), 
			array( 'animated-software_add_vectorpoint' => 'software add vectorpoint' ), 
			array( 'animated-software_box_oval' => 'software box oval' ), 
			array( 'animated-software_box_polygon' => 'software box polygon' ), 
			array( 'animated-software_box_rectangle' => 'software box rectangle' ), 
			array( 'animated-software_box_roundedrectangle' => 'software box roundedrectangle' ), 
			array( 'animated-software_character' => 'software character' ), 
			array( 'animated-software_crop' => 'software crop' ), 
			array( 'animated-software_eyedropper' => 'software eyedropper' ), 
			array( 'animated-software_font_allcaps' => 'software font allcaps' ), 
			array( 'animated-software_font_baseline_shift' => 'software font baseline shift' ), 
			array( 'animated-software_font_horizontal_scale' => 'software font horizontal scale' ), 
			array( 'animated-software_font_kerning' => 'software font kerning' ), 
			array( 'animated-software_font_leading' => 'software font leading' ), 
			array( 'animated-software_font_size' => 'software font size' ), 
			array( 'animated-software_font_smallcapital' => 'software font smallcapital' ), 
			array( 'animated-software_font_smallcaps' => 'software font smallcaps' ), 
			array( 'animated-software_font_strikethrough' => 'software font strikethrough' ), 
			array( 'animated-software_font_tracking' => 'software font tracking' ), 
			array( 'animated-software_font_underline' => 'software font underline' ), 
			array( 'animated-software_font_vertical_scale' => 'software font vertical scale' ), 
			array( 'animated-software_horizontal_align_center' => 'software horizontal align center' ), 
			array( 'animated-software_horizontal_align_right' => 'software horizontal align right' ), 
			array( 'animated-software_horizontal_distribute_center' => 'software horizontal distribute center' ), 
			array( 'animated-software_horizontal_distribute_left' => 'software horizontal distribute left' ), 
			array( 'animated-software_horizontal_distribute_right' => 'software horizontal distribute right' ), 
			array( 'animated-software_indent_firstline' => 'software indent firstline' ), 
			array( 'animated-software_indent_left' => 'software indent left' ), 
			array( 'animated-software_indent_right' => 'software indent right' ), 
			array( 'animated-software_lasso' => 'software lasso' ), 
			array( 'animated-software_layers1' => 'software layers1' ), 
			array( 'animated-software_layers2' => 'software layers2' ), 
			array( 'animated-software_layout-8boxes' => 'software layout 8boxes' ), 
			array( 'animated-software_layout' => 'software layout' ), 
			array( 'animated-software_layout_2columns' => 'software layout 2columns' ), 
			array( 'animated-software_layout_3columns' => 'software layout 3columns' ), 
			array( 'animated-software_layout_4boxes' => 'software layout 4boxes' ), 
			array( 'animated-software_layout_4columns' => 'software layout 4columns' ), 
			array( 'animated-software_layout_4lines' => 'software layout 4lines' ), 
			array( 'animated-software_layout_header' => 'software layout header' ), 
			array( 'animated-software_layout_header_2columns' => 'software layout header 2columns' ), 
			array( 'animated-software_layout_header_3columns' => 'software layout header 3columns' ), 
			array( 'animated-software_layout_header_4boxes' => 'software layout header 4boxes' ), 
			array( 'animated-software_layout_header_4columns' => 'software layout header 4columns' ), 
			array( 'animated-software_layout_header_complex2' => 'software layout header complex2' ), 
			array( 'animated-software_layout_header_complex3' => 'software layout header complex3' ), 
			array( 'animated-software_layout_header_complex4' => 'software layout header complex4' ), 
			array( 'animated-software_layout_header_complex' => 'software layout header complex' ), 
			array( 'animated-software_layout_header_sideleft' => 'software layout header sideleft' ), 
			array( 'animated-software_layout_header_sideright' => 'software layout header sideright' ), 
			array( 'animated-software_layout_sidebar_left' => 'software layout sidebar left' ), 
			array( 'animated-software_layout_sidebar_right' => 'software layout sidebar right' ), 
			array( 'animated-software_magnete' => 'software magnete' ), 
			array( 'animated-software_pages' => 'software pages' ), 
			array( 'animated-software_paintbrush' => 'software paintbrush' ), 
			array( 'animated-software_paintbucket' => 'software paintbucket' ), 
			array( 'animated-software_paintroller' => 'software paintroller' ), 
			array( 'animated-software_paragraph' => 'software paragraph' ), 
			array( 'animated-software_paragraph_align_left' => 'software paragraph align left' ), 
			array( 'animated-software_paragraph_align_right' => 'software paragraph align right' ), 
			array( 'animated-software_paragraph_center' => 'software paragraph center' ), 
			array( 'animated-software_paragraph_justify_all' => 'software paragraph justify all' ), 
			array( 'animated-software_paragraph_justify_center' => 'software paragraph justify center' ), 
			array( 'animated-software_paragraph_justify_left' => 'software paragraph justify left' ), 
			array( 'animated-software_paragraph_justify_right' => 'software paragraph justify right' ), 
			array( 'animated-software_paragraph_space_after' => 'software paragraph space after' ), 
			array( 'animated-software_paragraph_space_before' => 'software paragraph space before' ), 
			array( 'animated-software_pathfinder_exclude' => 'software pathfinder exclude' ), 
			array( 'animated-software_pathfinder_intersect' => 'software pathfinder intersect' ), 
			array( 'animated-software_pathfinder_subtract' => 'software pathfinder subtract' ), 
			array( 'animated-software_pathfinder_unite' => 'software pathfinder unite' ), 
			array( 'animated-software_pen' => 'software pen' ), 
			array( 'animated-software_pen_add' => 'software pen add' ), 
			array( 'animated-software_pen_remove' => 'software pen remove' ), 
			array( 'animated-software_pencil' => 'software pencil' ), 
			array( 'animated-software_polygonallasso' => 'software polygonallasso' ), 
			array( 'animated-software_reflect_horizontal' => 'software reflect horizontal' ), 
			array( 'animated-software_reflect_vertical' => 'software reflect vertical' ), 
			array( 'animated-software_remove_vectorpoint' => 'software remove vectorpoint' ), 
			array( 'animated-software_scale_expand' => 'software scale expand' ), 
			array( 'animated-software_scale_reduce' => 'software scale reduce' ), 
			array( 'animated-software_selection_oval' => 'software selection oval' ), 
			array( 'animated-software_selection_polygon' => 'software selection polygon' ), 
			array( 'animated-software_selection_rectangle' => 'software selection rectangle' ), 
			array( 'animated-software_selection_roundedrectangle' => 'software selection roundedrectangle' ), 
			array( 'animated-software_shape_oval' => 'software shape oval' ), 
			array( 'animated-software_shape_polygon' => 'software shape polygon' ), 
			array( 'animated-software_shape_rectangle' => 'software shape rectangle' ), 
			array( 'animated-software_shape_roundedrectangle' => 'software shape roundedrectangle' ), 
			array( 'animated-software_slice' => 'software slice' ), 
			array( 'animated-software_transform_bezier' => 'software transform bezier' ), 
			array( 'animated-software_vector_box' => 'software vector box' ), 
			array( 'animated-software_vector_composite' => 'software vector composite' ), 
			array( 'animated-software_vector_line' => 'software vector line' ), 
			array( 'animated-software_vertical_align_bottom' => 'software vertical align bottom' ), 
			array( 'animated-software_vertical_align_center' => 'software vertical align center' ), 
			array( 'animated-software_vertical_align_top' => 'software vertical align top' ), 
			array( 'animated-software_vertical_distribute_bottom' => 'software vertical distribute bottom' ), 
			array( 'animated-software_vertical_distribute_center' => 'software vertical distribute center' ), 
			array( 'animated-software_vertical_distribute_top' => 'software vertical distribute top' ),
		),
		'Weather' => array(
			array( 'animated-weather_aquarius' => 'weather aquarius' ), 
			array( 'animated-weather_aries' => 'weather aries' ), 
			array( 'animated-weather_cancer' => 'weather cancer' ), 
			array( 'animated-weather_capricorn' => 'weather capricorn' ), 
			array( 'animated-weather_cloud' => 'weather cloud' ), 
			array( 'animated-weather_cloud_drop' => 'weather cloud drop' ), 
			array( 'animated-weather_cloud_lightning' => 'weather cloud lightning' ), 
			array( 'animated-weather_cloud_snowflake' => 'weather cloud snowflake' ), 
			array( 'animated-weather_downpour_fullmoon' => 'weather downpour fullmoon' ), 
			array( 'animated-weather_downpour_halfmoon' => 'weather downpour halfmoon' ), 
			array( 'animated-weather_downpour_sun' => 'weather downpour sun' ), 
			array( 'animated-weather_drop' => 'weather drop' ), 
			array( 'animated-weather_first_quarter' => 'weather first quarter' ), 
			array( 'animated-weather_fog' => 'weather fog' ), 
			array( 'animated-weather_fog_fullmoon' => 'weather fog fullmoon' ), 
			array( 'animated-weather_fog_halfmoon' => 'weather fog halfmoon' ), 
			array( 'animated-weather_fog_sun' => 'weather fog sun' ), 
			array( 'animated-weather_fullmoon' => 'weather fullmoon' ), 
			array( 'animated-weather_gemini' => 'weather gemini' ), 
			array( 'animated-weather_hail' => 'weather hail' ), 
			array( 'animated-weather_hail_fullmoon' => 'weather hail fullmoon' ), 
			array( 'animated-weather_hail_halfmoon' => 'weather hail halfmoon' ), 
			array( 'animated-weather_hail_sun' => 'weather hail sun' ), 
			array( 'animated-weather_last_quarter' => 'weather last quarter' ), 
			array( 'animated-weather_leo' => 'weather leo' ), 
			array( 'animated-weather_libra' => 'weather libra' ), 
			array( 'animated-weather_lightning' => 'weather lightning' ), 
			array( 'animated-weather_mistyrain' => 'weather mistyrain' ), 
			array( 'animated-weather_mistyrain_fullmoon' => 'weather mistyrain fullmoon' ), 
			array( 'animated-weather_mistyrain_halfmoon' => 'weather mistyrain halfmoon' ), 
			array( 'animated-weather_mistyrain_sun' => 'weather mistyrain sun' ), 
			array( 'animated-weather_moon' => 'weather moon' ), 
			array( 'animated-weather_moondown_full' => 'weather moondown full' ), 
			array( 'animated-weather_moondown_half' => 'weather moondown half' ), 
			array( 'animated-weather_moonset_full' => 'weather moonset full' ), 
			array( 'animated-weather_moonset_half' => 'weather moonset half' ), 
			array( 'animated-weather_move2' => 'weather move2' ), 
			array( 'animated-weather_newmoon' => 'weather newmoon' ), 
			array( 'animated-weather_pisces' => 'weather pisces' ), 
			array( 'animated-weather_rain' => 'weather rain' ), 
			array( 'animated-weather_rain_fullmoon' => 'weather rain fullmoon' ), 
			array( 'animated-weather_rain_halfmoon' => 'weather rain halfmoon' ), 
			array( 'animated-weather_rain_sun' => 'weather rain sun' ), 
			array( 'animated-weather_sagittarius' => 'weather sagittarius' ), 
			array( 'animated-weather_scorpio' => 'weather scorpio' ), 
			array( 'animated-weather_snow' => 'weather snow' ), 
			array( 'animated-weather_snow_fullmoon' => 'weather snow fullmoon' ), 
			array( 'animated-weather_snow_halfmoon' => 'weather snow halfmoon' ), 
			array( 'animated-weather_snow_sun' => 'weather snow sun' ), 
			array( 'animated-weather_snowflake' => 'weather snowflake' ), 
			array( 'animated-weather_star' => 'weather star' ), 
			array( 'animated-weather_storm-11' => 'weather storm-11' ), 
			array( 'animated-weather_storm-32' => 'weather storm-32' ), 
			array( 'animated-weather_storm_fullmoon' => 'weather storm fullmoon' ), 
			array( 'animated-weather_storm_halfmoon' => 'weather storm halfmoon' ), 
			array( 'animated-weather_storm_sun' => 'weather storm sun' ), 
			array( 'animated-weather_sun' => 'weather sun' ), 
			array( 'animated-weather_sundown' => 'weather sundown' ), 
			array( 'animated-weather_sunset' => 'weather sunset' ), 
			array( 'animated-weather_taurus' => 'weather taurus' ), 
			array( 'animated-weather_tempest' => 'weather tempest' ), 
			array( 'animated-weather_tempest_fullmoon' => 'weather tempest fullmoon' ), 
			array( 'animated-weather_tempest_halfmoon' => 'weather tempest halfmoon' ), 
			array( 'animated-weather_tempest_sun' => 'weather tempest sun' ), 
			array( 'animated-weather_variable_fullmoon' => 'weather variable fullmoon' ), 
			array( 'animated-weather_variable_halfmoon' => 'weather variable halfmoon' ), 
			array( 'animated-weather_variable_sun' => 'weather variable sun' ), 
			array( 'animated-weather_virgo' => 'weather virgo' ), 
			array( 'animated-weather_waning_cresent' => 'weather waning cresent' ), 
			array( 'animated-weather_waning_gibbous' => 'weather waning gibbous' ), 
			array( 'animated-weather_waxing_cresent' => 'weather waxing cresent' ), 
			array( 'animated-weather_waxing_gibbous' => 'weather waxing gibbous' ), 
			array( 'animated-weather_wind' => 'weather wind' ), 
			array( 'animated-weather_wind_E' => 'weather wind_E' ), 
			array( 'animated-weather_wind_N' => 'weather wind_N' ), 
			array( 'animated-weather_wind_NE' => 'weather wind_NE' ), 
			array( 'animated-weather_wind_NW' => 'weather wind_NW' ), 
			array( 'animated-weather_wind_S' => 'weather wind_S' ), 
			array( 'animated-weather_wind_SE' => 'weather wind_SE' ), 
			array( 'animated-weather_wind_SW' => 'weather wind_SW' ), 
			array( 'animated-weather_wind_W' => 'weather wind_W' ), 
			array( 'animated-weather_wind_fullmoon' => 'weather wind fullmoon' ), 
			array( 'animated-weather_wind_halfmoon' => 'weather wind halfmoon' ), 
			array( 'animated-weather_wind_sun' => 'weather wind sun' ), 
			array( 'animated-weather_windgust' => 'weather windgust' ),
		)
	);
	
	return array_merge( $icons, $animated_icons );	
}
